/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.wathe.compat;

import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.VoicechatServerStartedEvent;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class TrainVoicePlugin
implements VoicechatPlugin {
    public static final UUID GROUP_ID = UUID.randomUUID();
    public static VoicechatServerApi SERVER_API;
    public static Group GROUP;

    public static boolean isVoiceChatMissing() {
        return SERVER_API == null;
    }

    public static void addPlayer(@NotNull UUID player) {
        if (TrainVoicePlugin.isVoiceChatMissing()) {
            return;
        }
        VoicechatConnection connection = SERVER_API.getConnectionOf(player);
        if (connection != null) {
            if (GROUP == null) {
                GROUP = SERVER_API.groupBuilder().setHidden(true).setId(GROUP_ID).setName("Train Spectators").setPersistent(true).setType(Group.Type.OPEN).build();
            }
            if (GROUP != null) {
                connection.setGroup(GROUP);
            }
        }
    }

    public static void resetPlayer(@NotNull UUID player) {
        if (TrainVoicePlugin.isVoiceChatMissing()) {
            return;
        }
        VoicechatConnection connection = SERVER_API.getConnectionOf(player);
        if (connection != null) {
            connection.setGroup(null);
        }
    }

    public void registerEvents(@NotNull EventRegistration registration) {
        registration.registerEvent(VoicechatServerStartedEvent.class, event -> {
            SERVER_API = event.getVoicechat();
        });
    }

    public String getPluginId() {
        return "wathe";
    }
}

